/*
    Hi I am Jat Kishan
        in this program we created doubly_linked_list with simple view


    some varibles

    *next       - is represent the next node
    *prev       - is represent the previous node

    *delnode    - node is use for free node space in memmory
    *head       - node known as first node
    *tail       - tail known as last node
    *node       - is travling node witch use for switching  node  to  next node
    *newnode    - contain new node for adding node
    count       - here count is lenth of linked list
    index       - for store position
    value       - contain insert value and delete value

*/

#include<stdio.h>
#include<stdlib.h>
#include<stdbool.h>

struct node {
    int value;
    struct node* next;
    struct node* prev;
};

typedef struct node NODE;

NODE* head, * tail;
int count = 0;

void addright(int value) {
    NODE* newnode;
    newnode = (NODE*)malloc(sizeof(NODE));
    newnode->value = value;
    newnode->next = NULL;
    newnode->prev = NULL;
    if (!head) {     //head == NULL
        head = tail = newnode;
    }
    else {
        // set previous
        newnode->prev = tail;

        // set newnode as last node
        tail->next = newnode;

        tail = newnode;
    }
    count++;
}

void addleft(int value) {
    NODE* newnode;
    newnode = (NODE*)malloc(sizeof(NODE));
    newnode->value = value;
    newnode->prev = NULL;
    if (!head) { // head == NULL
        head = tail = newnode;
    }
    else {
        newnode->next = head;
        head->prev = newnode;
        head = newnode;
    }
    count++;
}

void addmid(int index, int value) {
    // if the index is first position then call addleft() to add new element or value
    if (index == 1) {
        addleft(value);
        return;
    }


    // normaly addmid() run this code for mid addition

    NODE* node, * newnode;
    int indexCount = 0;
    newnode = (NODE*)malloc(sizeof(NODE));
    newnode->value = value;

    if (index > count) {
        printf("index is out of range!     <<<\n");
    }

    // add element in middle
    else {
        // check best side for node Switching

        if (count / 2 > index) {   // start from head
            node = head;
            indexCount++;
            while (indexCount < index) {
                node = node->next;
                indexCount++;
            }
        }
        else {     // start from tail
            indexCount = (count - index);
            node = tail;
            while (indexCount > 0) {
                node = node->prev;
                indexCount--;
            }
        }

        printf("value on position is %d", node->value);
        // add newnode between two nodes
        newnode->next = node;
        newnode->prev = node->prev;
        node->prev->next = newnode;
        node->prev = newnode;

        count++;
    }
}

int delright() {
    NODE* node;
    int value;
    if (!head) {     //head == NULL
        printf("List is empty!     <<<");
        return 0;
    }
    node = head;
    if (node == tail) {
        value = node->value;
        free(node);
        head = tail = NULL;
    }
    else {
        value = tail->value;
        tail = tail->prev;
        free(tail->next);
        tail->next = NULL;
    }
    count--;
    return value;
}

int delleft() {
    NODE* node;
    int value;
    if (!head) {     // head == NULL
        printf("List is empty!     <<<");
        return 0;
    }
    node = head;

    // if in list only one node exist than set head and tail as null
    if (node == tail) {
        value = node->value;
        free(node);
        head = tail = NULL;
    }

    // remove first node
    else {
        value = head->value;
        head = head->next;
        free(head->prev);
        head->prev = NULL;
    }
    count--;
    return value;
}

int delmid(int index) {
    NODE* node;
    int value, indexCount = 0;
    if (!head) { // head == NULL
        printf("List is empty!     <<<");
        return 0;
    }
    else if (index > count) {
        printf("index is out of range!     <<<\n");
        return 0;
    }

    // if index on first position then call delleft()
    else if (index == 1) {
        return delleft();
    }

    // if index on last position then call delright()
    else if (index == count) {
        return delright();
    }

    // get that index position address

    // check best side for node Switching

    if (count / 2 > index) {   // start from head
        node = head;
        indexCount++;
        while (indexCount < index) {
            node = node->next;
            indexCount++;
        }
    }
    else {     // start from tail
        indexCount = (count - index);
        node = tail;
        while (indexCount > 0) {
            node = node->prev;
            indexCount--;
        }
    }
    value = node->value;

    // remove depandency of deleting node
    node->prev->next = node->next;
    node->next->prev = node->prev;

    free(node);

    count--;
    return value;
}

void display() {
    NODE* node;

    if (!head)
        printf("\n[ Head = Empty ]     <<<");
    else {
        node = head;
        printf("\n[ Head = %d ]", node->value);

        // if (head == tail) { return; }
        if (!head->next) { return; }

        node = node->next;
        while (node->next) {
            if (node == tail) { break; }
            printf(" -> [ %d ]", node->value);
            node = node->next;
        }
        printf(" -> [ Tail = %d ]", node->value);
    }

}

int main() {
    int choise = 0, value, index;
    while (true) {
        printf("\nUse Doubly linked list\n1. Add elem right\n2. Add elem left\n3. Add elem mid\n4. Delete elem right\n5. Delete elem left\n6. Delete elem mid\n7. Display linked list\n0. Exit\n--> ");
        scanf("%d", &choise);

        switch (choise)
        {
        case 1:
        printf("Enter value: ");
        scanf("%d", &value);
        addright(value);
        break;
        case 2:
        printf("Enter value: ");
        scanf("%d", &value);
        addleft(value);
        break;
        case 3:
        printf("Enter Index: ");
        scanf("%d", &index);
        printf("Enter Value: ");
        scanf("%d", &value);
        addmid(index, value);
        break;
        case 4:
        printf("\tdeleted %d\n", delright());
        break;
        case 5:
        printf("\tdeleted %d\n", delleft());
        break;
        case 6:
        printf("Ener Index: ");
        scanf("%d", &index);
        printf("\tdeleted %d\n", delmid(index));
        break;
        case 7:
        display();
        break;
        case 0:
        printf(" ,,.,,\n`/'`'\\`\n|     |\n(~[@-@]\t\tThanks for useing doubly linked list data structure\n \\  -/ \n / \\/\\      ,_________\n|  . '\\     || Thank |\n|\\]    |]   ||__You__|\n `--______  .--_| |_\n          ``               \n\n");
        exit(0);
        default:
        printf("Not correct choise!     <<<");
        }
    }
    return 0;
}